import pandas as pd   
import pickle
import matplotlib.pyplot as plt

# Load the dataset
laptops_price = pd.read_csv("laptops_price.csv")

filtered_laptops['Total_Score'] = filtered_laptops.apply(lambda row: cpu_score(row['CPU']) + storage_score(row[' Storage']) + gpu_score(row['GPU']), axis=1)
ranked_laptops = filtered_laptops.sort_values(by='Total_Score', ascending=False)  

ranked_laptops[['Manufacturer', 'Model Name', 'CPU', 'RAM', ' Storage', 'GPU', 'Total_Score']].head(10)

print(ranked_laptops)
pickle.dump(ranked_laptops,open("./ref_result/ranked_laptops.pkl","wb"))
